/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifndef PCIEMEMINFO_H
#define PCIEMEMINFO_H

#include "AgtPCIPort.h"
#include "devpciedefs.h"

class CPCIEMemInfoProperty
{
public:
  UInt8  mPropNum;
  UInt32 mDefault;
  UInt8  mDwNum;
  UInt8  mBitSize;
  UInt8  mBitPos;
};

class CPCIEMemInfo
{
public:

  CPCIEMemInfo();
  ~CPCIEMemInfo();

  // ATTENTION: Do not modify order without changing order in source file
  enum MemProperty 
  {
    BLOCKMEM_R31 = 0,
    BLOCKMEM_FMT,
    BLOCKMEM_TYPE,
    BLOCKMEM_R23,
    BLOCKMEM_TC,
    BLOCKMEM_R19_16,
    BLOCKMEM_ATTR,
    BLOCKMEM_R11_10,
    BLOCKMEM_MARK,
    BLOCKMEM_REPEAT_NEXT,
    BLOCKMEM_ADDR_LO,
    BLOCKMEM_DATA_IND,
    BLOCKMEM_DATA_COMP,
    BLOCKMEM_ADDR_HI,
    BLOCKMEM_INT_ADDR_12_2,
    BLOCKMEM_LENGTH,

    BLOCKMEM_PATT,                  // Used pattern terms (bitmap) for wait/repeat until
    BLOCKMEM_WAITREPEAT,            // Determines wait/repeat behavior

    BLOCKMEM_ADDR_IS_64,
    BLOCKMEM_FCT_NUM,
    BLOCKMEM_FDW_BE,
    BLOCKMEM_LDW_BE,
    BLOCKMEM_INT_ADDR_20_13,
    BLOCKMEM_ADDR_LO_REGNUM_BITS,
    BLOCKMEM_ADDR_LO_EXTREGNUM_BITS,
    BLOCKMEM_ADDR_LO_RSVD107_BITS,
    BLOCKMEM_ADDR_LO_FUNCNUM_BITS,
    BLOCKMEM_ADDR_LO_DEVNUM_BITS,
    BLOCKMEM_ADDR_LO_BUSNUM_BITS,
    BLOCKMEM_FDW_LDW_BE_MCODE,
    BLOCKMEM_DATAIND_COMP,

    REQBEHMEM_GAP_12_0,
    REQBEHMEM_LENGTH,
    REQBEHMEM_REPEAT_NEXT,
    REQBEHMEM_INCORRECT_LCRC,
    REQBEHMEM_NULLIFIED_TLP,
    REQBEHMEM_WRONG_PYLD_SIZE,
    REQBEHMEM_INSERT_TD,
    REQBEHMEM_INCORRECT_ECRC,
    REQBEHMEM_INCORRECT_DISP,
    REQBEHMEM_EP,
    REQBEHMEM_TD,
    REQBEHMEM_TAG,
    REQBEHMEM_SW_TAG,
    REQBEHMEM_PRIORITY,
    REQBEHMEM_GAP_15_13,
    REQBEHMEM_REPLACE_STP,
    REQBEHMEM_REPLACE_END,
    REQBEHMEM_REPLACE_SEQNO,

    COMPBEHMEM_INCORRECT_LCRC,
    COMPBEHMEM_NULLIFIED_TLP,
    COMPBEHMEM_WRONG_PYLD_SIZE,
    COMPBEHMEM_INSERT_TD,
    COMPBEHMEM_INCORRECT_ECRC,
    COMPBEHMEM_INCORRECT_DISP,
    COMPBEHMEM_EP,
    COMPBEHMEM_TD,
    COMPBEHMEM_PRIORITY,
    COMPBEHMEM_COMPL_STATUS,
    COMPBEHMEM_RCBCOUNT,
    COMPBEHMEM_REPEAT_NEXT,
    COMPBEHMEM_REPLACE_STP,
    COMPBEHMEM_REPLACE_END,
    COMPBEHMEM_REPLACE_SEQNO,
    COMPBEHMEM_DISCARD,
    BLOCKMEM_END
  };

  // Block memories
  static UInt8 getBitPos( const EPCIEBlock& prop );
  static UInt8 getBitSize( const EPCIEBlock& prop );
  static UInt32 getDefault( const EPCIEBlock& prop );
  static UInt8 getDWNum( const EPCIEBlock& prop );
  static void setPropVal( const EPCIEBlock& prop, UInt32& currentVal, const UInt32& newOffsetValue );
  static void setPropDefaultVal( const EPCIEBlock& prop, UInt32& currentVal );
  static UInt32 getPropVal( const EPCIEBlock& prop, const UInt32& currentVal );

  static void intAddrWrite( const UInt32& val, UInt32& lowVal, UInt32& hiVal );
  static UInt32 intAddrRead( const UInt32& lowVal, const UInt32& hiVal );
  static void intAddrDefaultWrite( UInt32& lowVal, UInt32& hiVal );

  static void setIs64Bit( UInt32& val, const bool& is64bit );
  static bool getIs64Bit( const UInt32& val );

  // Requester behavior memories
  static UInt8 getBitPos( const EPCIEReqBeh& prop );
  static UInt8 getBitSize( const EPCIEReqBeh& prop );
  static UInt32 getDefault( const EPCIEReqBeh& prop );
  static UInt8 getDWNum( const EPCIEReqBeh& prop );
  static void setPropVal( const EPCIEReqBeh& prop, UInt32& currentVal, const UInt32& newOffsetValue );
  static void setPropDefaultVal( const EPCIEReqBeh& prop, UInt32& currentVal );
  static UInt32 getPropVal( const EPCIEReqBeh& prop, const UInt32& currentVal );

  static void gapWrite( const UInt32& val, UInt32& lowVal, UInt32& hiVal );
  static UInt32 gapRead( const UInt32& lowVal, const UInt32& hiVal );
  static void gapDefaultWrite( UInt32& lowVal, UInt32& hiVal );

  // Completer behavior memories
  static UInt8 getBitPos( const EPCIECompBeh& prop );
  static UInt8 getBitSize( const EPCIECompBeh& prop );
  static UInt32 getDefault( const EPCIECompBeh& prop );
  static UInt8 getDWNum( const EPCIECompBeh& prop );
  static void setPropVal( const EPCIECompBeh& prop, UInt32& currentVal, const UInt32& newOffsetValue );
  static void setPropDefaultVal( const EPCIECompBeh& prop, UInt32& currentVal );
  static UInt32 getPropVal( const EPCIECompBeh& prop, const UInt32& currentVal );

private:

  static void writeSplitVal( const UInt32& val, UInt32& lowVal, UInt32& hiVal, const MemProperty& lowProp,
    const MemProperty& hiProp );
  static UInt32 readSplitVal( const UInt32& lowVal, const UInt32& hiVal, const MemProperty& lowProp,
    const MemProperty& hiProp );
  static void splitValWriteDefault( UInt32& lowVal, UInt32& hiVal, const MemProperty& lowProp,
    const MemProperty& hiProp );

  static void setBits( UInt32& val, const UInt8& bitPos, const UInt8& bitSize, const UInt32& bitVal );
  static UInt32 getBits( const UInt32& val, const UInt8& bitPos, const UInt8& bitSize );

  static const CPCIEMemInfoProperty mPropTable[];

  static CPCIEMemInfoProperty getPropertyInfo( const EPCIEBlock& prop );
  static CPCIEMemInfoProperty getPropertyInfo( const EPCIEReqBeh& prop );
  static CPCIEMemInfoProperty getPropertyInfo( const EPCIECompBeh& prop );
};

#endif /* PCIEMEMINFO_H */